/* 
 * npecli.c
 *
 * Моделює роботу клієнта служби "Луна" на базі іменованих каналів
 * (із зворотним зв'язком між сервером і клієнтом).
 * Запитує в користувача повідомлення і передає їх серверу. Отримані 
 * від сервера відповіді виводить у стандартний потік виведення
 * результатів.
 * Ілюструє порядок застосування іменованих каналів.
 *
 */

#include "npe.h"

int main()
{
        char buf[BUFSIZE];
        int pdw, pdr;

        /* Відкриває на запис іменований канал, призначений для передачі
           повідомлень серверу (передбачається, що сервер попередньо
           створив цей канал). */
        pdw = open(PIPE_TO_SERVER, O_WRONLY);
        if (pdw < 0) {
                perror("open(PIPE_TO_SERVER, ...)");
                exit(EXIT_FAILURE);
        }
        /* Відкриває на читання іменований канал, призначений для
           отримання повідомлень від сервера (передбачається, що
           сервер попередньо створив цей канал). */
        pdr = open(PIPE_FROM_SERVER, O_RDONLY);
        if (pdr < 0) {
                perror("open(PIPE_FROM_SERVER, ...)");
                exit(EXIT_FAILURE);
        }
        /* Канали відкриваються в тому самому порядку,
         * що й серверній програмі!
         */

        do {
                /* Запитує від користувача повідомлення. */
                printf("Request: ");
                scanf("%s", buf);
                /* Передає повідомлення серверу. */
                if (write(pdw, buf, BUFSIZE) < 0) {
                        perror("write()");
                        exit(EXIT_FAILURE);
                }
                buf[0] = '\0';
                /* Отримує від сервера відповідь. */
                if (read(pdr, buf, BUFSIZE) < 0) {
                        perror("read()");
                        exit(EXIT_FAILURE);
                }
                /* Виводить відповідь сервера. */
                printf("Answer:  %s\n", buf);
                /* Запитує від користувача продовження роботи. */
                printf("Another request? [y/n] ");
                scanf("%s", buf);
        } while (!(strcmp(buf, "y") * strcmp(buf, "Y") 
                        * strcmp(buf, "yes") * strcmp(buf, "Yes")));

        exit(EXIT_SUCCESS);
}
